/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.servlet.logd.CachedData;
import com.ibm.hwmca.fw.servlet.logd.LaunchExpander;
import com.ibm.hwmca.fw.servlet.logd.LogBlockData;
import com.ibm.hwmca.fw.servlet.logd.LogDisplayerEvent;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.servlet.logd.LogServletMsg;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogDisplayerBlock {
    private static final String TRACE_MASKT = "XLDSBLKT";
    private static final String TRACE_MASKF = "XLDSBLKF";
    private static final String TRACE_MASKD = "XLDSBLKD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final int OFFSET_LOG_CLASS = 0;
    private static final int OFFSET_LOG_TYPE = 1;
    private static final int OFFSET_LOG_USER = 3;
    private static final String BLOCK_SPACE = " ";
    private static final String _logBlockTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.title").toString();
    private static final String _logBlockDataTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.blockdata.title").toString();
    private static final String _viewDataFileListText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.viewdatalist.name").toString();
    private static final String _primaryBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.primary.name").toString();
    private static final String _standardBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.standard.name").toString();
    private static final String _modifyBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.modify.name").toString();
    private static final String _systemEventBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.systemevent.name").toString();
    private static final String _engDataBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.engdata.name").toString();
    private static final String _mcodeBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.mcode.name").toString();
    private static final String _dataBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.data.name").toString();
    private static final String _hdwBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.hdwdata.name").toString();
    private static final String _secondaryBlockText = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.block.secondary.name").toString();

    private static Log getSelectedLog(LogBlockData logBlockData, String reqType) throws HException {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerBlock.getSelectedLog() for " + reqType);
        Log log = null;
        Trace.trace(TRACE_MASKF, "String log block info for class=" + logBlockData.getLogClass() + " type=" + logBlockData.getLogType() + " user=" + logBlockData.getLogUser());
        String key = logBlockData.getLogFileName() + logBlockData.getLogClass() + logBlockData.getLogType() + logBlockData.getLogUser() + logBlockData.getTimeStamp();
        Trace.trace(TRACE_MASKF, "log entry key=" + key);
        log = CachedData.getCachedData(key);
        if (log == null) {
            Trace.trace(TRACE_MASKF, "Must reread the log for the log entry:  key=" + key);
            Integer iLogClass = Integer.valueOf(logBlockData.getLogClass(), 16);
            byte bLogClass = iLogClass.byteValue();
            Integer iLogType = Integer.valueOf(logBlockData.getLogType(), 16);
            byte bLogType = iLogType.byteValue();
            Integer iLogUser = Integer.valueOf(logBlockData.getLogUser(), 16);
            short sLogUser = iLogUser.shortValue();
            Trace.trace(TRACE_MASKF, "log block info for class=" + HexString.toHex(bLogClass) + " type=" + HexString.toHex(bLogType) + " user=" + HexString.toHex(sLogUser));
            Date logDate = new Date(Long.parseLong(logBlockData.getTimeStamp()));
            LogEntryId logEntryId = null;
            logEntryId = logBlockData.getLogFileName().equals("log") ? new LogEntryId(null, bLogClass, bLogType, sLogUser, logDate) : new LogEntryId(logBlockData.getLogFileName(), bLogClass, bLogType, sLogUser, logDate);
            log = Log.retrieveMulti(logEntryId);
            if (log != null) {
                CachedData.putCachedData(key, log);
            }
        } else {
            Trace.trace(TRACE_MASKF, "got log data from map");
        }
        Trace.trace(TRACE_MASKT, "<- LogDisplayerBlock.getSelectedLog() for " + reqType);
        return log;
    }

    protected static Log getSelLogDisplayMsgIfProb(HttpServletRequest request, HttpServletResponse response, LogBlockData logBlockData, String title, short erridNoRead, String reqType) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "Read the selected log for " + reqType);
        Log log = null;
        try {
            log = LogDisplayerBlock.getSelectedLog(logBlockData, reqType);
            if (log == null) {
                Trace.trace(TRACE_MASKF, reqType + ":  The selected log entry is no longer in the log");
                LogServletMsg.displayMsg(request, response, title, "XLDSNTIL", MsgType.INFORMATION_MESSAGE);
            }
        }
        catch (HException hex) {
            Trace.trace(TRACE_MASKF, reqType + ": caught HException reading selected log entry");
            FrameworkLog fLog = new FrameworkLog(_logInfo, erridNoRead, hex);
            if (logBlockData.getLogClass() != null && logBlockData.getLogClass().length() != 0 && logBlockData.getLogType() != null && logBlockData.getLogType().length() != 0 && logBlockData.getLogUser() != null && logBlockData.getLogUser().length() != 0) {
                fLog.add(reqType + ": for " + logBlockData.getLogClass() + logBlockData.getLogType() + logBlockData.getLogUser() + " Name=" + logBlockData.getName() + " Date=" + logBlockData.getFormattedDate() + " Time=" + logBlockData.getFormattedTime());
            }
            fLog.log();
            log = null;
            throw hex;
        }
        return log;
    }

    public void getDisplayBlocks(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerBlock.getDisplayBlocks()");
        LogBlockData logBlockData = new LogBlockData(request);
        Trace.trace(TRACE_MASKF, "String log block info for class=" + logBlockData.getLogClass() + " type=" + logBlockData.getLogType() + " user=" + logBlockData.getLogUser());
        PrintWriter out = response.getWriter();
        Log log = null;
        String reqType = request.getParameter("reqtype");
        log = LogDisplayerBlock.getSelLogDisplayMsgIfProb(request, response, logBlockData, _logBlockDataTitle, (short)2180, reqType);
        if (log != null) {
            LogBlock[] logBlocks = log.getLogBlocks();
            Trace.trace(TRACE_MASKF, "Display the list of log blocks");
            out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _logBlockTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>");
            out.print(LogServlet.HTML_BACK + "<br>&nbsp;<br>");
            out.print(LogDisplayerEvent.format1EventLog(logBlockData).toString());
            out.print("<br>&nbsp;<br>&nbsp;<br>");
            this.displayBlocks(out, logBlocks, logBlockData);
            out.print("</pre> </body></html>");
        }
        Trace.trace(TRACE_MASKT, "<- LogBlock.getDisplayBlock()");
    }

    private void displayBlocks(PrintWriter out, LogBlock[] logBlocks, LogBlockData logBlockData) {
        String logBlockLinkStart = "<A href=\"logd?";
        String logBlockParm = "reqtype=logblockdata";
        String viewFileParm = "reqtype=viewflist";
        String logBlockEvent = LogDisplayerEvent.getEventData(logBlockData);
        String logBlockIdData = "&blockid=";
        String logBlockLinkMiddle = "\">";
        String logBlockLinkEnd = "</A>";
        out.print("Select an item to view its data: <br>");
        out.print(BLOCK_SPACE + logBlockLinkStart + viewFileParm + logBlockEvent + logBlockLinkMiddle + _viewDataFileListText + logBlockLinkEnd + "<br>&nbsp;<br>");
        if (logBlocks != null && logBlocks.length != 0) {
            if (this.blockExists((byte)3, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)3) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _primaryBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)1, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)1) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _standardBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)0, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)0) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _modifyBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)-15, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)-15) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _systemEventBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)2, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)2) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _engDataBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)-16, logBlocks)) {
                Trace.trace(TRACE_MASKF, "FOUND MCODE blockid=" + HexString.toHex((byte)-16));
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)-16) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _mcodeBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)-14, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)-14) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _dataBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            if (this.blockExists((byte)-12, logBlocks)) {
                out.print(BLOCK_SPACE + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + HexString.toHex((byte)-12) + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + _hdwBlockText + logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            this.processSecBlock(logBlocks, out, logBlockLinkStart, logBlockLinkMiddle, logBlockLinkEnd, logBlockParm, logBlockIdData, logBlockEvent, logBlockData);
        }
    }

    private boolean blockExists(byte blockId, LogBlock[] logBlocks) {
        boolean blockFound = false;
        int numBlocks = logBlocks.length;
        Trace.trace(TRACE_MASKF, "the blockId=" + HexString.toHex(blockId, true) + " num=" + numBlocks);
        for (int i = 0; i < numBlocks && !blockFound; ++i) {
            if (blockId != logBlocks[i].getBlockId()) continue;
            blockFound = true;
        }
        Trace.trace(TRACE_MASKF, "blockId=" + HexString.toHex(blockId, true) + " blockFound=" + blockFound);
        return blockFound;
    }

    private void processSecBlock(LogBlock[] logBlocks, PrintWriter out, String logBlockLinkStart, String logBlockLinkMiddle, String logBlockLinkEnd, String logBlockParm, String logBlockIdData, String logBlockEvent, LogBlockData logBlockData) {
        int blockId;
        int lowerSec = 4;
        int upperSec = -17;
        upperSec &= 0xFF;
        lowerSec &= 0xFF;
        int numBlocks = logBlocks.length;
        boolean specifySameAs = false;
        boolean blockFound = false;
        blockFound = false;
        for (int i = 0; i < numBlocks && !blockFound; ++i) {
            blockId = logBlocks[i].getBlockId();
            if (blockId != -19) continue;
            blockFound = true;
            byte[] edBlockData = (byte[])logBlocks[i].getData();
            if (edBlockData == null && edBlockData.length == 0) continue;
            String str = new String(edBlockData);
            if (!(str = str.trim()).equalsIgnoreCase("Same as EE block")) continue;
            specifySameAs = true;
        }
        Trace.trace(TRACE_MASKF, "For BlkED and BlkEE: specifySameAs=" + specifySameAs);
        int firstSec = 0;
        for (int i = 0; i < numBlocks; ++i) {
            blockId = logBlocks[i].getBlockId();
            int tmpBlockId = blockId;
            if ((tmpBlockId &= 0xFF) < lowerSec || tmpBlockId > upperSec) continue;
            if (firstSec == 0) {
                out.print(BLOCK_SPACE + _secondaryBlockText + "<br>");
            }
            String blockIdStr = null;
            blockIdStr = HexString.toHex((byte)blockId).toUpperCase();
            out.print("  " + logBlockLinkStart + logBlockParm + logBlockEvent + logBlockIdData + blockIdStr + "&" + "logfname" + "=" + logBlockData.getLogFileName() + logBlockLinkMiddle + blockIdStr);
            if (blockId == -19 && specifySameAs) {
                out.print(logBlockLinkEnd + " - " + "Same as EE block" + "<br>&nbsp;<br>");
            } else {
                out.print(logBlockLinkEnd + "<br>&nbsp;<br>");
            }
            ++firstSec;
        }
    }

    public void displayBlockData(HttpServletRequest request, HttpServletResponse response) throws IOException, HException {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerBlock.getDisplayBlocks()");
        Log log = null;
        LogBlockData logBlockData = new LogBlockData(request);
        Integer iBlockid = Integer.valueOf(logBlockData.getBlockid(), 16);
        byte bBlockid = iBlockid.byteValue();
        Trace.trace(TRACE_MASKF, "String log block info for class=" + logBlockData.getLogClass() + " type=" + logBlockData.getLogType() + " user=" + logBlockData.getLogUser() + " blockid=" + HexString.toHex(bBlockid));
        PrintWriter out = response.getWriter();
        String reqType = request.getParameter("reqtype");
        log = LogDisplayerBlock.getSelLogDisplayMsgIfProb(request, response, logBlockData, _logBlockDataTitle, (short)2181, reqType);
        if (log != null) {
            Trace.trace(TRACE_MASKF, "blockid=" + HexString.toHex(bBlockid));
            LogBlock logBlock = log.getLogBlock(bBlockid);
            if (logBlock == null) {
                Trace.trace(TRACE_MASKF, "There is no log block data in the log entry");
                LogServletMsg.displayMsg(request, response, _logBlockDataTitle, "XLDSLBND", MsgType.INFORMATION_MESSAGE);
            } else {
                Trace.trace(TRACE_MASKF, "Before launching the expander");
                LaunchExpander.launchExpander(log, logBlock, logBlockData, request, response);
                Trace.trace(TRACE_MASKF, "After launching the expander");
            }
        }
        Trace.trace(TRACE_MASKT, "<- LogBlock.getDisplayBlock()");
    }
}

